# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .attachment_field_setting import AttachmentFieldSetting
from .date_time_field_setting import DateTimeFieldSetting
from .enum_field_setting import EnumFieldSetting
from .image_field_setting import ImageFieldSetting
from .lookup_field_setting import LookupFieldSetting
from .number_field_setting import NumberFieldSetting
from .text_field_setting import TextFieldSetting


class CommonSchemaConfig(object):
    _types = {
        "text_field_setting": TextFieldSetting,
        "number_field_setting": NumberFieldSetting,
        "enum_field_setting": EnumFieldSetting,
        "lookup_field_setting": LookupFieldSetting,
        "date_time_field_setting": DateTimeFieldSetting,
        "attachment_field_setting": AttachmentFieldSetting,
        "image_field_setting": ImageFieldSetting,
    }

    def __init__(self, d=None):
        self.text_field_setting: Optional[TextFieldSetting] = None
        self.number_field_setting: Optional[NumberFieldSetting] = None
        self.enum_field_setting: Optional[EnumFieldSetting] = None
        self.lookup_field_setting: Optional[LookupFieldSetting] = None
        self.date_time_field_setting: Optional[DateTimeFieldSetting] = None
        self.attachment_field_setting: Optional[AttachmentFieldSetting] = None
        self.image_field_setting: Optional[ImageFieldSetting] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CommonSchemaConfigBuilder":
        return CommonSchemaConfigBuilder()


class CommonSchemaConfigBuilder(object):
    def __init__(self) -> None:
        self._common_schema_config = CommonSchemaConfig()

    def text_field_setting(self, text_field_setting: TextFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.text_field_setting = text_field_setting
        return self

    def number_field_setting(self, number_field_setting: NumberFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.number_field_setting = number_field_setting
        return self

    def enum_field_setting(self, enum_field_setting: EnumFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.enum_field_setting = enum_field_setting
        return self

    def lookup_field_setting(self, lookup_field_setting: LookupFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.lookup_field_setting = lookup_field_setting
        return self

    def date_time_field_setting(self, date_time_field_setting: DateTimeFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.date_time_field_setting = date_time_field_setting
        return self

    def attachment_field_setting(self, attachment_field_setting: AttachmentFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.attachment_field_setting = attachment_field_setting
        return self

    def image_field_setting(self, image_field_setting: ImageFieldSetting) -> "CommonSchemaConfigBuilder":
        self._common_schema_config.image_field_setting = image_field_setting
        return self

    def build(self) -> "CommonSchemaConfig":
        return self._common_schema_config
