# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .name import Name


class CommonSchemaOption(object):
    _types = {
        "api_name": str,
        "name": Name,
        "description": Name,
        "is_open": bool,
    }

    def __init__(self, d=None):
        self.api_name: Optional[str] = None
        self.name: Optional[Name] = None
        self.description: Optional[Name] = None
        self.is_open: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CommonSchemaOptionBuilder":
        return CommonSchemaOptionBuilder()


class CommonSchemaOptionBuilder(object):
    def __init__(self) -> None:
        self._common_schema_option = CommonSchemaOption()

    def api_name(self, api_name: str) -> "CommonSchemaOptionBuilder":
        self._common_schema_option.api_name = api_name
        return self

    def name(self, name: Name) -> "CommonSchemaOptionBuilder":
        self._common_schema_option.name = name
        return self

    def description(self, description: Name) -> "CommonSchemaOptionBuilder":
        self._common_schema_option.description = description
        return self

    def is_open(self, is_open: bool) -> "CommonSchemaOptionBuilder":
        self._common_schema_option.is_open = is_open
        return self

    def build(self) -> "CommonSchemaOption":
        return self._common_schema_option
