# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n
from .object_field_data import ObjectFieldData
from .support_cost_center_item import SupportCostCenterItem


class CostCenter(object):
    _types = {
        "is_autogenerate": bool,
        "id": str,
        "name": List[I18n],
        "active": bool,
        "code": str,
        "description": List[I18n],
        "effective_time": str,
        "expiration_time": str,
        "managers": List[str],
        "parent": str,
        "custom_fields": List[ObjectFieldData],
        "employment_id": str,
        "rate": int,
        "support_cost_center": List[SupportCostCenterItem],
    }

    def __init__(self, d=None):
        self.is_autogenerate: Optional[bool] = None
        self.id: Optional[str] = None
        self.name: Optional[List[I18n]] = None
        self.active: Optional[bool] = None
        self.code: Optional[str] = None
        self.description: Optional[List[I18n]] = None
        self.effective_time: Optional[str] = None
        self.expiration_time: Optional[str] = None
        self.managers: Optional[List[str]] = None
        self.parent: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        self.employment_id: Optional[str] = None
        self.rate: Optional[int] = None
        self.support_cost_center: Optional[List[SupportCostCenterItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CostCenterBuilder":
        return CostCenterBuilder()


class CostCenterBuilder(object):
    def __init__(self) -> None:
        self._cost_center = CostCenter()

    def is_autogenerate(self, is_autogenerate: bool) -> "CostCenterBuilder":
        self._cost_center.is_autogenerate = is_autogenerate
        return self

    def id(self, id: str) -> "CostCenterBuilder":
        self._cost_center.id = id
        return self

    def name(self, name: List[I18n]) -> "CostCenterBuilder":
        self._cost_center.name = name
        return self

    def active(self, active: bool) -> "CostCenterBuilder":
        self._cost_center.active = active
        return self

    def code(self, code: str) -> "CostCenterBuilder":
        self._cost_center.code = code
        return self

    def description(self, description: List[I18n]) -> "CostCenterBuilder":
        self._cost_center.description = description
        return self

    def effective_time(self, effective_time: str) -> "CostCenterBuilder":
        self._cost_center.effective_time = effective_time
        return self

    def expiration_time(self, expiration_time: str) -> "CostCenterBuilder":
        self._cost_center.expiration_time = expiration_time
        return self

    def managers(self, managers: List[str]) -> "CostCenterBuilder":
        self._cost_center.managers = managers
        return self

    def parent(self, parent: str) -> "CostCenterBuilder":
        self._cost_center.parent = parent
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "CostCenterBuilder":
        self._cost_center.custom_fields = custom_fields
        return self

    def employment_id(self, employment_id: str) -> "CostCenterBuilder":
        self._cost_center.employment_id = employment_id
        return self

    def rate(self, rate: int) -> "CostCenterBuilder":
        self._cost_center.rate = rate
        return self

    def support_cost_center(self, support_cost_center: List[SupportCostCenterItem]) -> "CostCenterBuilder":
        self._cost_center.support_cost_center = support_cost_center
        return self

    def build(self) -> "CostCenter":
        return self._cost_center
