# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .contract import Contract


class CreateContractRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.request_body: Optional[Contract] = None

    @staticmethod
    def builder() -> "CreateContractRequestBuilder":
        return CreateContractRequestBuilder()


class CreateContractRequestBuilder(object):

    def __init__(self) -> None:
        create_contract_request = CreateContractRequest()
        create_contract_request.http_method = HttpMethod.POST
        create_contract_request.uri = "/open-apis/corehr/v1/contracts"
        create_contract_request.token_types = {AccessTokenType.TENANT}
        self._create_contract_request: CreateContractRequest = create_contract_request

    def client_token(self, client_token: str) -> "CreateContractRequestBuilder":
        self._create_contract_request.client_token = client_token
        self._create_contract_request.add_query("client_token", client_token)
        return self

    def request_body(self, request_body: Contract) -> "CreateContractRequestBuilder":
        self._create_contract_request.request_body = request_body
        self._create_contract_request.body = request_body
        return self

    def build(self) -> CreateContractRequest:
        return self._create_contract_request
