# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .employee_type import EmployeeType


class CreateEmployeeTypeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.request_body: Optional[EmployeeType] = None

    @staticmethod
    def builder() -> "CreateEmployeeTypeRequestBuilder":
        return CreateEmployeeTypeRequestBuilder()


class CreateEmployeeTypeRequestBuilder(object):

    def __init__(self) -> None:
        create_employee_type_request = CreateEmployeeTypeRequest()
        create_employee_type_request.http_method = HttpMethod.POST
        create_employee_type_request.uri = "/open-apis/corehr/v1/employee_types"
        create_employee_type_request.token_types = {AccessTokenType.TENANT}
        self._create_employee_type_request: CreateEmployeeTypeRequest = create_employee_type_request

    def client_token(self, client_token: str) -> "CreateEmployeeTypeRequestBuilder":
        self._create_employee_type_request.client_token = client_token
        self._create_employee_type_request.add_query("client_token", client_token)
        return self

    def request_body(self, request_body: EmployeeType) -> "CreateEmployeeTypeRequestBuilder":
        self._create_employee_type_request.request_body = request_body
        self._create_employee_type_request.body = request_body
        return self

    def build(self) -> CreateEmployeeTypeRequest:
        return self._create_employee_type_request
