# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .transfer_info import TransferInfo


class CreateJobChangeRequestBody(object):
    _types = {
        "transfer_mode": int,
        "employment_id": str,
        "transfer_type_unique_identifier": str,
        "flow_id": str,
        "effective_date": str,
        "transfer_info": TransferInfo,
        "transfer_key": str,
        "initiator_id": str,
    }

    def __init__(self, d=None):
        self.transfer_mode: Optional[int] = None
        self.employment_id: Optional[str] = None
        self.transfer_type_unique_identifier: Optional[str] = None
        self.flow_id: Optional[str] = None
        self.effective_date: Optional[str] = None
        self.transfer_info: Optional[TransferInfo] = None
        self.transfer_key: Optional[str] = None
        self.initiator_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateJobChangeRequestBodyBuilder":
        return CreateJobChangeRequestBodyBuilder()


class CreateJobChangeRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_job_change_request_body = CreateJobChangeRequestBody()

    def transfer_mode(self, transfer_mode: int) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.transfer_mode = transfer_mode
        return self

    def employment_id(self, employment_id: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.employment_id = employment_id
        return self

    def transfer_type_unique_identifier(self,
                                        transfer_type_unique_identifier: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.transfer_type_unique_identifier = transfer_type_unique_identifier
        return self

    def flow_id(self, flow_id: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.flow_id = flow_id
        return self

    def effective_date(self, effective_date: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.effective_date = effective_date
        return self

    def transfer_info(self, transfer_info: TransferInfo) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.transfer_info = transfer_info
        return self

    def transfer_key(self, transfer_key: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.transfer_key = transfer_key
        return self

    def initiator_id(self, initiator_id: str) -> "CreateJobChangeRequestBodyBuilder":
        self._create_job_change_request_body.initiator_id = initiator_id
        return self

    def build(self) -> "CreateJobChangeRequestBody":
        return self._create_job_change_request_body
