# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_leave_granting_record_request_body import CreateLeaveGrantingRecordRequestBody


class CreateLeaveGrantingRecordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[CreateLeaveGrantingRecordRequestBody] = None

    @staticmethod
    def builder() -> "CreateLeaveGrantingRecordRequestBuilder":
        return CreateLeaveGrantingRecordRequestBuilder()


class CreateLeaveGrantingRecordRequestBuilder(object):

    def __init__(self) -> None:
        create_leave_granting_record_request = CreateLeaveGrantingRecordRequest()
        create_leave_granting_record_request.http_method = HttpMethod.POST
        create_leave_granting_record_request.uri = "/open-apis/corehr/v1/leave_granting_records"
        create_leave_granting_record_request.token_types = {AccessTokenType.TENANT}
        self._create_leave_granting_record_request: CreateLeaveGrantingRecordRequest = create_leave_granting_record_request

    def user_id_type(self, user_id_type: str) -> "CreateLeaveGrantingRecordRequestBuilder":
        self._create_leave_granting_record_request.user_id_type = user_id_type
        self._create_leave_granting_record_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self,
                     request_body: CreateLeaveGrantingRecordRequestBody) -> "CreateLeaveGrantingRecordRequestBuilder":
        self._create_leave_granting_record_request.request_body = request_body
        self._create_leave_granting_record_request.body = request_body
        return self

    def build(self) -> CreateLeaveGrantingRecordRequest:
        return self._create_leave_granting_record_request
