# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteContractRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.contract_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteContractRequestBuilder":
        return DeleteContractRequestBuilder()


class DeleteContractRequestBuilder(object):

    def __init__(self) -> None:
        delete_contract_request = DeleteContractRequest()
        delete_contract_request.http_method = HttpMethod.DELETE
        delete_contract_request.uri = "/open-apis/corehr/v1/contracts/:contract_id"
        delete_contract_request.token_types = {AccessTokenType.TENANT}
        self._delete_contract_request: DeleteContractRequest = delete_contract_request

    def contract_id(self, contract_id: str) -> "DeleteContractRequestBuilder":
        self._delete_contract_request.contract_id = contract_id
        self._delete_contract_request.paths["contract_id"] = str(contract_id)
        return self

    def build(self) -> DeleteContractRequest:
        return self._delete_contract_request
