# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteEmploymentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.employment_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteEmploymentRequestBuilder":
        return DeleteEmploymentRequestBuilder()


class DeleteEmploymentRequestBuilder(object):

    def __init__(self) -> None:
        delete_employment_request = DeleteEmploymentRequest()
        delete_employment_request.http_method = HttpMethod.DELETE
        delete_employment_request.uri = "/open-apis/corehr/v1/employments/:employment_id"
        delete_employment_request.token_types = {AccessTokenType.TENANT}
        self._delete_employment_request: DeleteEmploymentRequest = delete_employment_request

    def user_id_type(self, user_id_type: str) -> "DeleteEmploymentRequestBuilder":
        self._delete_employment_request.user_id_type = user_id_type
        self._delete_employment_request.add_query("user_id_type", user_id_type)
        return self

    def employment_id(self, employment_id: str) -> "DeleteEmploymentRequestBuilder":
        self._delete_employment_request.employment_id = employment_id
        self._delete_employment_request.paths["employment_id"] = str(employment_id)
        return self

    def build(self) -> DeleteEmploymentRequest:
        return self._delete_employment_request
