# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteJobDataRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.job_data_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteJobDataRequestBuilder":
        return DeleteJobDataRequestBuilder()


class DeleteJobDataRequestBuilder(object):

    def __init__(self) -> None:
        delete_job_data_request = DeleteJobDataRequest()
        delete_job_data_request.http_method = HttpMethod.DELETE
        delete_job_data_request.uri = "/open-apis/corehr/v1/job_datas/:job_data_id"
        delete_job_data_request.token_types = {AccessTokenType.TENANT}
        self._delete_job_data_request: DeleteJobDataRequest = delete_job_data_request

    def job_data_id(self, job_data_id: str) -> "DeleteJobDataRequestBuilder":
        self._delete_job_data_request.job_data_id = job_data_id
        self._delete_job_data_request.paths["job_data_id"] = str(job_data_id)
        return self

    def build(self) -> DeleteJobDataRequest:
        return self._delete_job_data_request
