# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeletePersonRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.person_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeletePersonRequestBuilder":
        return DeletePersonRequestBuilder()


class DeletePersonRequestBuilder(object):

    def __init__(self) -> None:
        delete_person_request = DeletePersonRequest()
        delete_person_request.http_method = HttpMethod.DELETE
        delete_person_request.uri = "/open-apis/corehr/v1/persons/:person_id"
        delete_person_request.token_types = {AccessTokenType.TENANT}
        self._delete_person_request: DeletePersonRequest = delete_person_request

    def person_id(self, person_id: str) -> "DeletePersonRequestBuilder":
        self._delete_person_request.person_id = person_id
        self._delete_person_request.paths["person_id"] = str(person_id)
        return self

    def build(self) -> DeletePersonRequest:
        return self._delete_person_request
