# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class Enum(object):
    _types = {
        "enum_name": str,
        "display": List[I18n],
    }

    def __init__(self, d=None):
        self.enum_name: Optional[str] = None
        self.display: Optional[List[I18n]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EnumBuilder":
        return EnumBuilder()


class EnumBuilder(object):
    def __init__(self) -> None:
        self._enum = Enum()

    def enum_name(self, enum_name: str) -> "EnumBuilder":
        self._enum.enum_name = enum_name
        return self

    def display(self, display: List[I18n]) -> "EnumBuilder":
        self._enum.display = display
        return self

    def build(self) -> "Enum":
        return self._enum
