# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .name import Name


class EnumFieldOption(object):
    _types = {
        "option_api_name": str,
        "active": bool,
        "name": Name,
    }

    def __init__(self, d=None):
        self.option_api_name: Optional[str] = None
        self.active: Optional[bool] = None
        self.name: Optional[Name] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EnumFieldOptionBuilder":
        return EnumFieldOptionBuilder()


class EnumFieldOptionBuilder(object):
    def __init__(self) -> None:
        self._enum_field_option = EnumFieldOption()

    def option_api_name(self, option_api_name: str) -> "EnumFieldOptionBuilder":
        self._enum_field_option.option_api_name = option_api_name
        return self

    def active(self, active: bool) -> "EnumFieldOptionBuilder":
        self._enum_field_option.active = active
        return self

    def name(self, name: Name) -> "EnumFieldOptionBuilder":
        self._enum_field_option.name = name
        return self

    def build(self) -> "EnumFieldOption":
        return self._enum_field_option
