# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .form_field_variable_bool_value import FormFieldVariableBoolValue
from .form_field_variable_date_value import FormFieldVariableDateValue
from .form_field_variable_datetime_value import FormFieldVariableDatetimeValue
from .form_field_variable_department_value import FormFieldVariableDepartmentValue
from .form_field_variable_employment_value import FormFieldVariableEmploymentValue
from .form_field_variable_enum_value import FormFieldVariableEnumValue
from .form_field_variable_file_value import FormFieldVariableFileValue
from .form_field_variable_i18n_value import FormFieldVariableI18nValue
from .form_field_variable_null_value import FormFieldVariableNullValue
from .form_field_variable_number_value import FormFieldVariableNumberValue
from .form_field_variable_object_value import FormFieldVariableObjectValue
from .form_field_variable_text_value import FormFieldVariableTextValue


class FormFieldVariableListObject(object):
    _types = {
        "text_value": FormFieldVariableTextValue,
        "number_value": FormFieldVariableNumberValue,
        "date_value": FormFieldVariableDateValue,
        "employment_value": FormFieldVariableEmploymentValue,
        "date_time_value": FormFieldVariableDatetimeValue,
        "enum_value": FormFieldVariableEnumValue,
        "null_value": FormFieldVariableNullValue,
        "bool_value": FormFieldVariableBoolValue,
        "department_value": FormFieldVariableDepartmentValue,
        "file_value": FormFieldVariableFileValue,
        "i18n_value": FormFieldVariableI18nValue,
        "object_value": FormFieldVariableObjectValue,
    }

    def __init__(self, d=None):
        self.text_value: Optional[FormFieldVariableTextValue] = None
        self.number_value: Optional[FormFieldVariableNumberValue] = None
        self.date_value: Optional[FormFieldVariableDateValue] = None
        self.employment_value: Optional[FormFieldVariableEmploymentValue] = None
        self.date_time_value: Optional[FormFieldVariableDatetimeValue] = None
        self.enum_value: Optional[FormFieldVariableEnumValue] = None
        self.null_value: Optional[FormFieldVariableNullValue] = None
        self.bool_value: Optional[FormFieldVariableBoolValue] = None
        self.department_value: Optional[FormFieldVariableDepartmentValue] = None
        self.file_value: Optional[FormFieldVariableFileValue] = None
        self.i18n_value: Optional[FormFieldVariableI18nValue] = None
        self.object_value: Optional[FormFieldVariableObjectValue] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FormFieldVariableListObjectBuilder":
        return FormFieldVariableListObjectBuilder()


class FormFieldVariableListObjectBuilder(object):
    def __init__(self) -> None:
        self._form_field_variable_list_object = FormFieldVariableListObject()

    def text_value(self, text_value: FormFieldVariableTextValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.text_value = text_value
        return self

    def number_value(self, number_value: FormFieldVariableNumberValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.number_value = number_value
        return self

    def date_value(self, date_value: FormFieldVariableDateValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.date_value = date_value
        return self

    def employment_value(self,
                         employment_value: FormFieldVariableEmploymentValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.employment_value = employment_value
        return self

    def date_time_value(self, date_time_value: FormFieldVariableDatetimeValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.date_time_value = date_time_value
        return self

    def enum_value(self, enum_value: FormFieldVariableEnumValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.enum_value = enum_value
        return self

    def null_value(self, null_value: FormFieldVariableNullValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.null_value = null_value
        return self

    def bool_value(self, bool_value: FormFieldVariableBoolValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.bool_value = bool_value
        return self

    def department_value(self,
                         department_value: FormFieldVariableDepartmentValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.department_value = department_value
        return self

    def file_value(self, file_value: FormFieldVariableFileValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.file_value = file_value
        return self

    def i18n_value(self, i18n_value: FormFieldVariableI18nValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.i18n_value = i18n_value
        return self

    def object_value(self, object_value: FormFieldVariableObjectValue) -> "FormFieldVariableListObjectBuilder":
        self._form_field_variable_list_object.object_value = object_value
        return self

    def build(self) -> "FormFieldVariableListObject":
        return self._form_field_variable_list_object
