# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetContractRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.contract_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetContractRequestBuilder":
        return GetContractRequestBuilder()


class GetContractRequestBuilder(object):

    def __init__(self) -> None:
        get_contract_request = GetContractRequest()
        get_contract_request.http_method = HttpMethod.GET
        get_contract_request.uri = "/open-apis/corehr/v1/contracts/:contract_id"
        get_contract_request.token_types = {AccessTokenType.TENANT}
        self._get_contract_request: GetContractRequest = get_contract_request

    def contract_id(self, contract_id: str) -> "GetContractRequestBuilder":
        self._get_contract_request.contract_id = contract_id
        self._get_contract_request.paths["contract_id"] = str(contract_id)
        return self

    def build(self) -> GetContractRequest:
        return self._get_contract_request
