# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetJobDataRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.job_data_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetJobDataRequestBuilder":
        return GetJobDataRequestBuilder()


class GetJobDataRequestBuilder(object):

    def __init__(self) -> None:
        get_job_data_request = GetJobDataRequest()
        get_job_data_request.http_method = HttpMethod.GET
        get_job_data_request.uri = "/open-apis/corehr/v1/job_datas/:job_data_id"
        get_job_data_request.token_types = {AccessTokenType.TENANT}
        self._get_job_data_request: GetJobDataRequest = get_job_data_request

    def user_id_type(self, user_id_type: str) -> "GetJobDataRequestBuilder":
        self._get_job_data_request.user_id_type = user_id_type
        self._get_job_data_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "GetJobDataRequestBuilder":
        self._get_job_data_request.department_id_type = department_id_type
        self._get_job_data_request.add_query("department_id_type", department_id_type)
        return self

    def job_data_id(self, job_data_id: str) -> "GetJobDataRequestBuilder":
        self._get_job_data_request.job_data_id = job_data_id
        self._get_job_data_request.paths["job_data_id"] = str(job_data_id)
        return self

    def build(self) -> GetJobDataRequest:
        return self._get_job_data_request
