# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class LeaveBalance(object):
    _types = {
        "leave_type_id": str,
        "leave_type_name": List[I18n],
        "historical_cycles_left": str,
        "this_cycle_total": str,
        "this_cycle_taken": str,
        "leave_balance": str,
        "leave_duration_unit": int,
    }

    def __init__(self, d=None):
        self.leave_type_id: Optional[str] = None
        self.leave_type_name: Optional[List[I18n]] = None
        self.historical_cycles_left: Optional[str] = None
        self.this_cycle_total: Optional[str] = None
        self.this_cycle_taken: Optional[str] = None
        self.leave_balance: Optional[str] = None
        self.leave_duration_unit: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LeaveBalanceBuilder":
        return LeaveBalanceBuilder()


class LeaveBalanceBuilder(object):
    def __init__(self) -> None:
        self._leave_balance = LeaveBalance()

    def leave_type_id(self, leave_type_id: str) -> "LeaveBalanceBuilder":
        self._leave_balance.leave_type_id = leave_type_id
        return self

    def leave_type_name(self, leave_type_name: List[I18n]) -> "LeaveBalanceBuilder":
        self._leave_balance.leave_type_name = leave_type_name
        return self

    def historical_cycles_left(self, historical_cycles_left: str) -> "LeaveBalanceBuilder":
        self._leave_balance.historical_cycles_left = historical_cycles_left
        return self

    def this_cycle_total(self, this_cycle_total: str) -> "LeaveBalanceBuilder":
        self._leave_balance.this_cycle_total = this_cycle_total
        return self

    def this_cycle_taken(self, this_cycle_taken: str) -> "LeaveBalanceBuilder":
        self._leave_balance.this_cycle_taken = this_cycle_taken
        return self

    def leave_balance(self, leave_balance: str) -> "LeaveBalanceBuilder":
        self._leave_balance.leave_balance = leave_balance
        return self

    def leave_duration_unit(self, leave_duration_unit: int) -> "LeaveBalanceBuilder":
        self._leave_balance.leave_duration_unit = leave_duration_unit
        return self

    def build(self) -> "LeaveBalance":
        return self._leave_balance
