# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class LeaveBalancesLeaveRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None
        self.as_of_date: Optional[str] = None
        self.employment_id_list: Optional[List[str]] = None
        self.user_id_type: Optional[str] = None
        self.time_zone: Optional[str] = None

    @staticmethod
    def builder() -> "LeaveBalancesLeaveRequestBuilder":
        return LeaveBalancesLeaveRequestBuilder()


class LeaveBalancesLeaveRequestBuilder(object):

    def __init__(self) -> None:
        leave_balances_leave_request = LeaveBalancesLeaveRequest()
        leave_balances_leave_request.http_method = HttpMethod.GET
        leave_balances_leave_request.uri = "/open-apis/corehr/v1/leaves/leave_balances"
        leave_balances_leave_request.token_types = {AccessTokenType.TENANT}
        self._leave_balances_leave_request: LeaveBalancesLeaveRequest = leave_balances_leave_request

    def page_token(self, page_token: str) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.page_token = page_token
        self._leave_balances_leave_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.page_size = page_size
        self._leave_balances_leave_request.add_query("page_size", page_size)
        return self

    def as_of_date(self, as_of_date: str) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.as_of_date = as_of_date
        self._leave_balances_leave_request.add_query("as_of_date", as_of_date)
        return self

    def employment_id_list(self, employment_id_list: List[str]) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.employment_id_list = employment_id_list
        self._leave_balances_leave_request.add_query("employment_id_list", employment_id_list)
        return self

    def user_id_type(self, user_id_type: str) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.user_id_type = user_id_type
        self._leave_balances_leave_request.add_query("user_id_type", user_id_type)
        return self

    def time_zone(self, time_zone: str) -> "LeaveBalancesLeaveRequestBuilder":
        self._leave_balances_leave_request.time_zone = time_zone
        self._leave_balances_leave_request.add_query("time_zone", time_zone)
        return self

    def build(self) -> LeaveBalancesLeaveRequest:
        return self._leave_balances_leave_request
