# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class LeaveRequestHistoryLeaveRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None
        self.employment_id_list: Optional[List[str]] = None
        self.initiator_id_list: Optional[List[str]] = None
        self.leave_request_status: Optional[List[str]] = None
        self.leave_type_id_list: Optional[List[str]] = None
        self.leave_start_date_min: Optional[str] = None
        self.leave_start_date_max: Optional[str] = None
        self.leave_end_date_min: Optional[str] = None
        self.leave_end_date_max: Optional[str] = None
        self.leave_submit_date_min: Optional[str] = None
        self.leave_submit_date_max: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.leave_update_time_min: Optional[str] = None
        self.leave_update_time_max: Optional[str] = None
        self.return_detail: Optional[bool] = None
        self.leave_term_type: Optional[int] = None
        self.time_zone: Optional[str] = None
        self.data_source: Optional[int] = None

    @staticmethod
    def builder() -> "LeaveRequestHistoryLeaveRequestBuilder":
        return LeaveRequestHistoryLeaveRequestBuilder()


class LeaveRequestHistoryLeaveRequestBuilder(object):

    def __init__(self) -> None:
        leave_request_history_leave_request = LeaveRequestHistoryLeaveRequest()
        leave_request_history_leave_request.http_method = HttpMethod.GET
        leave_request_history_leave_request.uri = "/open-apis/corehr/v1/leaves/leave_request_history"
        leave_request_history_leave_request.token_types = {AccessTokenType.TENANT}
        self._leave_request_history_leave_request: LeaveRequestHistoryLeaveRequest = leave_request_history_leave_request

    def page_token(self, page_token: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.page_token = page_token
        self._leave_request_history_leave_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.page_size = page_size
        self._leave_request_history_leave_request.add_query("page_size", page_size)
        return self

    def employment_id_list(self, employment_id_list: List[str]) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.employment_id_list = employment_id_list
        self._leave_request_history_leave_request.add_query("employment_id_list", employment_id_list)
        return self

    def initiator_id_list(self, initiator_id_list: List[str]) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.initiator_id_list = initiator_id_list
        self._leave_request_history_leave_request.add_query("initiator_id_list", initiator_id_list)
        return self

    def leave_request_status(self, leave_request_status: List[str]) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_request_status = leave_request_status
        self._leave_request_history_leave_request.add_query("leave_request_status", leave_request_status)
        return self

    def leave_type_id_list(self, leave_type_id_list: List[str]) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_type_id_list = leave_type_id_list
        self._leave_request_history_leave_request.add_query("leave_type_id_list", leave_type_id_list)
        return self

    def leave_start_date_min(self, leave_start_date_min: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_start_date_min = leave_start_date_min
        self._leave_request_history_leave_request.add_query("leave_start_date_min", leave_start_date_min)
        return self

    def leave_start_date_max(self, leave_start_date_max: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_start_date_max = leave_start_date_max
        self._leave_request_history_leave_request.add_query("leave_start_date_max", leave_start_date_max)
        return self

    def leave_end_date_min(self, leave_end_date_min: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_end_date_min = leave_end_date_min
        self._leave_request_history_leave_request.add_query("leave_end_date_min", leave_end_date_min)
        return self

    def leave_end_date_max(self, leave_end_date_max: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_end_date_max = leave_end_date_max
        self._leave_request_history_leave_request.add_query("leave_end_date_max", leave_end_date_max)
        return self

    def leave_submit_date_min(self, leave_submit_date_min: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_submit_date_min = leave_submit_date_min
        self._leave_request_history_leave_request.add_query("leave_submit_date_min", leave_submit_date_min)
        return self

    def leave_submit_date_max(self, leave_submit_date_max: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_submit_date_max = leave_submit_date_max
        self._leave_request_history_leave_request.add_query("leave_submit_date_max", leave_submit_date_max)
        return self

    def user_id_type(self, user_id_type: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.user_id_type = user_id_type
        self._leave_request_history_leave_request.add_query("user_id_type", user_id_type)
        return self

    def leave_update_time_min(self, leave_update_time_min: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_update_time_min = leave_update_time_min
        self._leave_request_history_leave_request.add_query("leave_update_time_min", leave_update_time_min)
        return self

    def leave_update_time_max(self, leave_update_time_max: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_update_time_max = leave_update_time_max
        self._leave_request_history_leave_request.add_query("leave_update_time_max", leave_update_time_max)
        return self

    def return_detail(self, return_detail: bool) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.return_detail = return_detail
        self._leave_request_history_leave_request.add_query("return_detail", return_detail)
        return self

    def leave_term_type(self, leave_term_type: int) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.leave_term_type = leave_term_type
        self._leave_request_history_leave_request.add_query("leave_term_type", leave_term_type)
        return self

    def time_zone(self, time_zone: str) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.time_zone = time_zone
        self._leave_request_history_leave_request.add_query("time_zone", time_zone)
        return self

    def data_source(self, data_source: int) -> "LeaveRequestHistoryLeaveRequestBuilder":
        self._leave_request_history_leave_request.data_source = data_source
        self._leave_request_history_leave_request.add_query("data_source", data_source)
        return self

    def build(self) -> LeaveRequestHistoryLeaveRequest:
        return self._leave_request_history_leave_request
