# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class LeaveTypesLeaveRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None
        self.status: Optional[str] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "LeaveTypesLeaveRequestBuilder":
        return LeaveTypesLeaveRequestBuilder()


class LeaveTypesLeaveRequestBuilder(object):

    def __init__(self) -> None:
        leave_types_leave_request = LeaveTypesLeaveRequest()
        leave_types_leave_request.http_method = HttpMethod.GET
        leave_types_leave_request.uri = "/open-apis/corehr/v1/leaves/leave_types"
        leave_types_leave_request.token_types = {AccessTokenType.TENANT}
        self._leave_types_leave_request: LeaveTypesLeaveRequest = leave_types_leave_request

    def page_token(self, page_token: str) -> "LeaveTypesLeaveRequestBuilder":
        self._leave_types_leave_request.page_token = page_token
        self._leave_types_leave_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "LeaveTypesLeaveRequestBuilder":
        self._leave_types_leave_request.page_size = page_size
        self._leave_types_leave_request.add_query("page_size", page_size)
        return self

    def status(self, status: str) -> "LeaveTypesLeaveRequestBuilder":
        self._leave_types_leave_request.status = status
        self._leave_types_leave_request.add_query("status", status)
        return self

    def user_id_type(self, user_id_type: str) -> "LeaveTypesLeaveRequestBuilder":
        self._leave_types_leave_request.user_id_type = user_id_type
        self._leave_types_leave_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> LeaveTypesLeaveRequest:
        return self._leave_types_leave_request
