# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListCompanyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None

    @staticmethod
    def builder() -> "ListCompanyRequestBuilder":
        return ListCompanyRequestBuilder()


class ListCompanyRequestBuilder(object):

    def __init__(self) -> None:
        list_company_request = ListCompanyRequest()
        list_company_request.http_method = HttpMethod.GET
        list_company_request.uri = "/open-apis/corehr/v1/companies"
        list_company_request.token_types = {AccessTokenType.TENANT}
        self._list_company_request: ListCompanyRequest = list_company_request

    def page_token(self, page_token: str) -> "ListCompanyRequestBuilder":
        self._list_company_request.page_token = page_token
        self._list_company_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "ListCompanyRequestBuilder":
        self._list_company_request.page_size = page_size
        self._list_company_request.add_query("page_size", page_size)
        return self

    def build(self) -> ListCompanyRequest:
        return self._list_company_request
