# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .contract import Contract


class ListContractResponseBody(object):
    _types = {
        "items": List[Contract],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Contract]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListContractResponseBodyBuilder":
        return ListContractResponseBodyBuilder()


class ListContractResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_contract_response_body = ListContractResponseBody()

    def items(self, items: List[Contract]) -> "ListContractResponseBodyBuilder":
        self._list_contract_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListContractResponseBodyBuilder":
        self._list_contract_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListContractResponseBodyBuilder":
        self._list_contract_response_body.page_token = page_token
        return self

    def build(self) -> "ListContractResponseBody":
        return self._list_contract_response_body
