# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .currency import Currency


class ListCurrencyResponseBody(object):
    _types = {
        "items": List[Currency],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Currency]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListCurrencyResponseBodyBuilder":
        return ListCurrencyResponseBodyBuilder()


class ListCurrencyResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_currency_response_body = ListCurrencyResponseBody()

    def items(self, items: List[Currency]) -> "ListCurrencyResponseBodyBuilder":
        self._list_currency_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListCurrencyResponseBodyBuilder":
        self._list_currency_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListCurrencyResponseBodyBuilder":
        self._list_currency_response_body.page_token = page_token
        return self

    def build(self) -> "ListCurrencyResponseBody":
        return self._list_currency_response_body
