# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListEmployeeTypeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None

    @staticmethod
    def builder() -> "ListEmployeeTypeRequestBuilder":
        return ListEmployeeTypeRequestBuilder()


class ListEmployeeTypeRequestBuilder(object):

    def __init__(self) -> None:
        list_employee_type_request = ListEmployeeTypeRequest()
        list_employee_type_request.http_method = HttpMethod.GET
        list_employee_type_request.uri = "/open-apis/corehr/v1/employee_types"
        list_employee_type_request.token_types = {AccessTokenType.TENANT}
        self._list_employee_type_request: ListEmployeeTypeRequest = list_employee_type_request

    def page_token(self, page_token: str) -> "ListEmployeeTypeRequestBuilder":
        self._list_employee_type_request.page_token = page_token
        self._list_employee_type_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "ListEmployeeTypeRequestBuilder":
        self._list_employee_type_request.page_size = page_size
        self._list_employee_type_request.add_query("page_size", page_size)
        return self

    def build(self) -> ListEmployeeTypeRequest:
        return self._list_employee_type_request
