# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .employee_type import EmployeeType


class ListEmployeeTypeResponseBody(object):
    _types = {
        "items": List[EmployeeType],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[EmployeeType]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListEmployeeTypeResponseBodyBuilder":
        return ListEmployeeTypeResponseBodyBuilder()


class ListEmployeeTypeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_employee_type_response_body = ListEmployeeTypeResponseBody()

    def items(self, items: List[EmployeeType]) -> "ListEmployeeTypeResponseBodyBuilder":
        self._list_employee_type_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListEmployeeTypeResponseBodyBuilder":
        self._list_employee_type_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListEmployeeTypeResponseBodyBuilder":
        self._list_employee_type_response_body.page_token = page_token
        return self

    def build(self) -> "ListEmployeeTypeResponseBody":
        return self._list_employee_type_response_body
