# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .location import Location


class ListLocationResponseBody(object):
    _types = {
        "items": List[Location],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Location]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListLocationResponseBodyBuilder":
        return ListLocationResponseBodyBuilder()


class ListLocationResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_location_response_body = ListLocationResponseBody()

    def items(self, items: List[Location]) -> "ListLocationResponseBodyBuilder":
        self._list_location_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListLocationResponseBodyBuilder":
        self._list_location_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListLocationResponseBodyBuilder":
        self._list_location_response_body.page_token = page_token
        return self

    def build(self) -> "ListLocationResponseBody":
        return self._list_location_response_body
