# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListNationalIdTypeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None
        self.identification_type: Optional[str] = None
        self.code: Optional[str] = None
        self.country_region_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListNationalIdTypeRequestBuilder":
        return ListNationalIdTypeRequestBuilder()


class ListNationalIdTypeRequestBuilder(object):

    def __init__(self) -> None:
        list_national_id_type_request = ListNationalIdTypeRequest()
        list_national_id_type_request.http_method = HttpMethod.GET
        list_national_id_type_request.uri = "/open-apis/corehr/v1/national_id_types"
        list_national_id_type_request.token_types = {AccessTokenType.TENANT}
        self._list_national_id_type_request: ListNationalIdTypeRequest = list_national_id_type_request

    def page_token(self, page_token: str) -> "ListNationalIdTypeRequestBuilder":
        self._list_national_id_type_request.page_token = page_token
        self._list_national_id_type_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "ListNationalIdTypeRequestBuilder":
        self._list_national_id_type_request.page_size = page_size
        self._list_national_id_type_request.add_query("page_size", page_size)
        return self

    def identification_type(self, identification_type: str) -> "ListNationalIdTypeRequestBuilder":
        self._list_national_id_type_request.identification_type = identification_type
        self._list_national_id_type_request.add_query("identification_type", identification_type)
        return self

    def code(self, code: str) -> "ListNationalIdTypeRequestBuilder":
        self._list_national_id_type_request.code = code
        self._list_national_id_type_request.add_query("code", code)
        return self

    def country_region_id(self, country_region_id: str) -> "ListNationalIdTypeRequestBuilder":
        self._list_national_id_type_request.country_region_id = country_region_id
        self._list_national_id_type_request.add_query("country_region_id", country_region_id)
        return self

    def build(self) -> ListNationalIdTypeRequest:
        return self._list_national_id_type_request
