# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .pre_hire_query import PreHireQuery


class ListPreHireResponseBody(object):
    _types = {
        "items": List[PreHireQuery],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[PreHireQuery]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListPreHireResponseBodyBuilder":
        return ListPreHireResponseBodyBuilder()


class ListPreHireResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_pre_hire_response_body = ListPreHireResponseBody()

    def items(self, items: List[PreHireQuery]) -> "ListPreHireResponseBodyBuilder":
        self._list_pre_hire_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListPreHireResponseBodyBuilder":
        self._list_pre_hire_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListPreHireResponseBodyBuilder":
        self._list_pre_hire_response_body.page_token = page_token
        return self

    def build(self) -> "ListPreHireResponseBody":
        return self._list_pre_hire_response_body
