# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .security_group import SecurityGroup


class ListSecurityGroupResponseBody(object):
    _types = {
        "items": List[SecurityGroup],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[SecurityGroup]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListSecurityGroupResponseBodyBuilder":
        return ListSecurityGroupResponseBodyBuilder()


class ListSecurityGroupResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_security_group_response_body = ListSecurityGroupResponseBody()

    def items(self, items: List[SecurityGroup]) -> "ListSecurityGroupResponseBodyBuilder":
        self._list_security_group_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListSecurityGroupResponseBodyBuilder":
        self._list_security_group_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListSecurityGroupResponseBodyBuilder":
        self._list_security_group_response_body.page_token = page_token
        return self

    def build(self) -> "ListSecurityGroupResponseBody":
        return self._list_security_group_response_body
