# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .working_hours_type import WorkingHoursType


class ListWorkingHoursTypeResponseBody(object):
    _types = {
        "items": List[WorkingHoursType],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[WorkingHoursType]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListWorkingHoursTypeResponseBodyBuilder":
        return ListWorkingHoursTypeResponseBodyBuilder()


class ListWorkingHoursTypeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_working_hours_type_response_body = ListWorkingHoursTypeResponseBody()

    def items(self, items: List[WorkingHoursType]) -> "ListWorkingHoursTypeResponseBodyBuilder":
        self._list_working_hours_type_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "ListWorkingHoursTypeResponseBodyBuilder":
        self._list_working_hours_type_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListWorkingHoursTypeResponseBodyBuilder":
        self._list_working_hours_type_response_body.page_token = page_token
        return self

    def build(self) -> "ListWorkingHoursTypeResponseBody":
        return self._list_working_hours_type_response_body
