# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .cpst_grade import CpstGrade


class MatchCompensationStandardResponseBody(object):
    _types = {
        "standard_id": str,
        "grade": CpstGrade,
        "effective_time": str,
    }

    def __init__(self, d=None):
        self.standard_id: Optional[str] = None
        self.grade: Optional[CpstGrade] = None
        self.effective_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MatchCompensationStandardResponseBodyBuilder":
        return MatchCompensationStandardResponseBodyBuilder()


class MatchCompensationStandardResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._match_compensation_standard_response_body = MatchCompensationStandardResponseBody()

    def standard_id(self, standard_id: str) -> "MatchCompensationStandardResponseBodyBuilder":
        self._match_compensation_standard_response_body.standard_id = standard_id
        return self

    def grade(self, grade: CpstGrade) -> "MatchCompensationStandardResponseBodyBuilder":
        self._match_compensation_standard_response_body.grade = grade
        return self

    def effective_time(self, effective_time: str) -> "MatchCompensationStandardResponseBodyBuilder":
        self._match_compensation_standard_response_body.effective_time = effective_time
        return self

    def build(self) -> "MatchCompensationStandardResponseBody":
        return self._match_compensation_standard_response_body
