# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .enum import Enum
from .i18n import I18n
from .object_field_data import ObjectFieldData


class NationalIdType(object):
    _types = {
        "id": str,
        "country_region_id": str,
        "name": List[I18n],
        "active": bool,
        "validation_rule": str,
        "validation_rule_description": List[I18n],
        "code": str,
        "identification_type": Enum,
        "custom_fields": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.country_region_id: Optional[str] = None
        self.name: Optional[List[I18n]] = None
        self.active: Optional[bool] = None
        self.validation_rule: Optional[str] = None
        self.validation_rule_description: Optional[List[I18n]] = None
        self.code: Optional[str] = None
        self.identification_type: Optional[Enum] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NationalIdTypeBuilder":
        return NationalIdTypeBuilder()


class NationalIdTypeBuilder(object):
    def __init__(self) -> None:
        self._national_id_type = NationalIdType()

    def id(self, id: str) -> "NationalIdTypeBuilder":
        self._national_id_type.id = id
        return self

    def country_region_id(self, country_region_id: str) -> "NationalIdTypeBuilder":
        self._national_id_type.country_region_id = country_region_id
        return self

    def name(self, name: List[I18n]) -> "NationalIdTypeBuilder":
        self._national_id_type.name = name
        return self

    def active(self, active: bool) -> "NationalIdTypeBuilder":
        self._national_id_type.active = active
        return self

    def validation_rule(self, validation_rule: str) -> "NationalIdTypeBuilder":
        self._national_id_type.validation_rule = validation_rule
        return self

    def validation_rule_description(self, validation_rule_description: List[I18n]) -> "NationalIdTypeBuilder":
        self._national_id_type.validation_rule_description = validation_rule_description
        return self

    def code(self, code: str) -> "NationalIdTypeBuilder":
        self._national_id_type.code = code
        return self

    def identification_type(self, identification_type: Enum) -> "NationalIdTypeBuilder":
        self._national_id_type.identification_type = identification_type
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "NationalIdTypeBuilder":
        self._national_id_type.custom_fields = custom_fields
        return self

    def build(self) -> "NationalIdType":
        return self._national_id_type
