# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class NumberFieldSetting(object):
    _types = {
        "number_field_type": int,
        "decimal_places": int,
        "round_type": int,
        "decimal_total_places": int,
    }

    def __init__(self, d=None):
        self.number_field_type: Optional[int] = None
        self.decimal_places: Optional[int] = None
        self.round_type: Optional[int] = None
        self.decimal_total_places: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NumberFieldSettingBuilder":
        return NumberFieldSettingBuilder()


class NumberFieldSettingBuilder(object):
    def __init__(self) -> None:
        self._number_field_setting = NumberFieldSetting()

    def number_field_type(self, number_field_type: int) -> "NumberFieldSettingBuilder":
        self._number_field_setting.number_field_type = number_field_type
        return self

    def decimal_places(self, decimal_places: int) -> "NumberFieldSettingBuilder":
        self._number_field_setting.decimal_places = decimal_places
        return self

    def round_type(self, round_type: int) -> "NumberFieldSettingBuilder":
        self._number_field_setting.round_type = round_type
        return self

    def decimal_total_places(self, decimal_total_places: int) -> "NumberFieldSettingBuilder":
        self._number_field_setting.decimal_total_places = decimal_total_places
        return self

    def build(self) -> "NumberFieldSetting":
        return self._number_field_setting
