# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .name import Name


class Object(object):
    _types = {
        "object_api_name": str,
        "name": Name,
        "is_open": bool,
        "create_time": str,
        "update_time": str,
    }

    def __init__(self, d=None):
        self.object_api_name: Optional[str] = None
        self.name: Optional[Name] = None
        self.is_open: Optional[bool] = None
        self.create_time: Optional[str] = None
        self.update_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ObjectBuilder":
        return ObjectBuilder()


class ObjectBuilder(object):
    def __init__(self) -> None:
        self._object = Object()

    def object_api_name(self, object_api_name: str) -> "ObjectBuilder":
        self._object.object_api_name = object_api_name
        return self

    def name(self, name: Name) -> "ObjectBuilder":
        self._object.name = name
        return self

    def is_open(self, is_open: bool) -> "ObjectBuilder":
        self._object.is_open = is_open
        return self

    def create_time(self, create_time: str) -> "ObjectBuilder":
        self._object.create_time = create_time
        return self

    def update_time(self, update_time: str) -> "ObjectBuilder":
        self._object.update_time = update_time
        return self

    def build(self) -> "Object":
        return self._object
