# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .object_field_data import ObjectFieldData


class ObjectData(object):
    _types = {
        "object_name": str,
        "id": str,
        "field_list": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.object_name: Optional[str] = None
        self.id: Optional[str] = None
        self.field_list: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ObjectDataBuilder":
        return ObjectDataBuilder()


class ObjectDataBuilder(object):
    def __init__(self) -> None:
        self._object_data = ObjectData()

    def object_name(self, object_name: str) -> "ObjectDataBuilder":
        self._object_data.object_name = object_name
        return self

    def id(self, id: str) -> "ObjectDataBuilder":
        self._object_data.id = id
        return self

    def field_list(self, field_list: List[ObjectFieldData]) -> "ObjectDataBuilder":
        self._object_data.field_list = field_list
        return self

    def build(self) -> "ObjectData":
        return self._object_data
