# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .application_info import ApplicationInfo
from .offboarding_checklist import OffboardingChecklist
from .offboarding_info import OffboardingInfo


class Offboarding(object):
    _types = {
        "initiating_type": str,
        "status": str,
        "application_info": ApplicationInfo,
        "offboarding_info": OffboardingInfo,
        "offboarding_checklist": OffboardingChecklist,
        "offboarding_id": str,
    }

    def __init__(self, d=None):
        self.initiating_type: Optional[str] = None
        self.status: Optional[str] = None
        self.application_info: Optional[ApplicationInfo] = None
        self.offboarding_info: Optional[OffboardingInfo] = None
        self.offboarding_checklist: Optional[OffboardingChecklist] = None
        self.offboarding_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OffboardingBuilder":
        return OffboardingBuilder()


class OffboardingBuilder(object):
    def __init__(self) -> None:
        self._offboarding = Offboarding()

    def initiating_type(self, initiating_type: str) -> "OffboardingBuilder":
        self._offboarding.initiating_type = initiating_type
        return self

    def status(self, status: str) -> "OffboardingBuilder":
        self._offboarding.status = status
        return self

    def application_info(self, application_info: ApplicationInfo) -> "OffboardingBuilder":
        self._offboarding.application_info = application_info
        return self

    def offboarding_info(self, offboarding_info: OffboardingInfo) -> "OffboardingBuilder":
        self._offboarding.offboarding_info = offboarding_info
        return self

    def offboarding_checklist(self, offboarding_checklist: OffboardingChecklist) -> "OffboardingBuilder":
        self._offboarding.offboarding_checklist = offboarding_checklist
        return self

    def offboarding_id(self, offboarding_id: str) -> "OffboardingBuilder":
        self._offboarding.offboarding_id = offboarding_id
        return self

    def build(self) -> "Offboarding":
        return self._offboarding
