# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class OffboardingData(object):
    _types = {
        "offboarding_id": str,
        "employment_id": str,
        "offboarding_reason_unique_identifier": str,
        "offboarding_date": str,
        "offboarding_reason_explanation": str,
        "created_time": str,
    }

    def __init__(self, d=None):
        self.offboarding_id: Optional[str] = None
        self.employment_id: Optional[str] = None
        self.offboarding_reason_unique_identifier: Optional[str] = None
        self.offboarding_date: Optional[str] = None
        self.offboarding_reason_explanation: Optional[str] = None
        self.created_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OffboardingDataBuilder":
        return OffboardingDataBuilder()


class OffboardingDataBuilder(object):
    def __init__(self) -> None:
        self._offboarding_data = OffboardingData()

    def offboarding_id(self, offboarding_id: str) -> "OffboardingDataBuilder":
        self._offboarding_data.offboarding_id = offboarding_id
        return self

    def employment_id(self, employment_id: str) -> "OffboardingDataBuilder":
        self._offboarding_data.employment_id = employment_id
        return self

    def offboarding_reason_unique_identifier(self,
                                             offboarding_reason_unique_identifier: str) -> "OffboardingDataBuilder":
        self._offboarding_data.offboarding_reason_unique_identifier = offboarding_reason_unique_identifier
        return self

    def offboarding_date(self, offboarding_date: str) -> "OffboardingDataBuilder":
        self._offboarding_data.offboarding_date = offboarding_date
        return self

    def offboarding_reason_explanation(self, offboarding_reason_explanation: str) -> "OffboardingDataBuilder":
        self._offboarding_data.offboarding_reason_explanation = offboarding_reason_explanation
        return self

    def created_time(self, created_time: str) -> "OffboardingDataBuilder":
        self._offboarding_data.created_time = created_time
        return self

    def build(self) -> "OffboardingData":
        return self._offboarding_data
