# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .custom_field_data import CustomFieldData
from .enum import Enum


class OffboardingInfo(object):
    _types = {
        "employment_id": str,
        "hrbp_id": List[str],
        "expected_offboarding_date": str,
        "offboarding_date": str,
        "reason": Enum,
        "reason_explanation": str,
        "employee_reason": Enum,
        "employee_reason_explanation": str,
        "add_block_list": str,
        "block_reason": Enum,
        "block_reason_explanation": str,
        "custom_fields": List[CustomFieldData],
    }

    def __init__(self, d=None):
        self.employment_id: Optional[str] = None
        self.hrbp_id: Optional[List[str]] = None
        self.expected_offboarding_date: Optional[str] = None
        self.offboarding_date: Optional[str] = None
        self.reason: Optional[Enum] = None
        self.reason_explanation: Optional[str] = None
        self.employee_reason: Optional[Enum] = None
        self.employee_reason_explanation: Optional[str] = None
        self.add_block_list: Optional[str] = None
        self.block_reason: Optional[Enum] = None
        self.block_reason_explanation: Optional[str] = None
        self.custom_fields: Optional[List[CustomFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OffboardingInfoBuilder":
        return OffboardingInfoBuilder()


class OffboardingInfoBuilder(object):
    def __init__(self) -> None:
        self._offboarding_info = OffboardingInfo()

    def employment_id(self, employment_id: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.employment_id = employment_id
        return self

    def hrbp_id(self, hrbp_id: List[str]) -> "OffboardingInfoBuilder":
        self._offboarding_info.hrbp_id = hrbp_id
        return self

    def expected_offboarding_date(self, expected_offboarding_date: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.expected_offboarding_date = expected_offboarding_date
        return self

    def offboarding_date(self, offboarding_date: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.offboarding_date = offboarding_date
        return self

    def reason(self, reason: Enum) -> "OffboardingInfoBuilder":
        self._offboarding_info.reason = reason
        return self

    def reason_explanation(self, reason_explanation: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.reason_explanation = reason_explanation
        return self

    def employee_reason(self, employee_reason: Enum) -> "OffboardingInfoBuilder":
        self._offboarding_info.employee_reason = employee_reason
        return self

    def employee_reason_explanation(self, employee_reason_explanation: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.employee_reason_explanation = employee_reason_explanation
        return self

    def add_block_list(self, add_block_list: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.add_block_list = add_block_list
        return self

    def block_reason(self, block_reason: Enum) -> "OffboardingInfoBuilder":
        self._offboarding_info.block_reason = block_reason
        return self

    def block_reason_explanation(self, block_reason_explanation: str) -> "OffboardingInfoBuilder":
        self._offboarding_info.block_reason_explanation = block_reason_explanation
        return self

    def custom_fields(self, custom_fields: List[CustomFieldData]) -> "OffboardingInfoBuilder":
        self._offboarding_info.custom_fields = custom_fields
        return self

    def build(self) -> "OffboardingInfo":
        return self._offboarding_info
