# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .company import Company


class PatchCompanyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.company_id: Optional[str] = None
        self.request_body: Optional[Company] = None

    @staticmethod
    def builder() -> "PatchCompanyRequestBuilder":
        return PatchCompanyRequestBuilder()


class PatchCompanyRequestBuilder(object):

    def __init__(self) -> None:
        patch_company_request = PatchCompanyRequest()
        patch_company_request.http_method = HttpMethod.PATCH
        patch_company_request.uri = "/open-apis/corehr/v1/companies/:company_id"
        patch_company_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_company_request: PatchCompanyRequest = patch_company_request

    def client_token(self, client_token: str) -> "PatchCompanyRequestBuilder":
        self._patch_company_request.client_token = client_token
        self._patch_company_request.add_query("client_token", client_token)
        return self

    def company_id(self, company_id: str) -> "PatchCompanyRequestBuilder":
        self._patch_company_request.company_id = company_id
        self._patch_company_request.paths["company_id"] = str(company_id)
        return self

    def request_body(self, request_body: Company) -> "PatchCompanyRequestBuilder":
        self._patch_company_request.request_body = request_body
        self._patch_company_request.body = request_body
        return self

    def build(self) -> PatchCompanyRequest:
        return self._patch_company_request
