# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .job_level import JobLevel


class PatchJobLevelRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.job_level_id: Optional[str] = None
        self.request_body: Optional[JobLevel] = None

    @staticmethod
    def builder() -> "PatchJobLevelRequestBuilder":
        return PatchJobLevelRequestBuilder()


class PatchJobLevelRequestBuilder(object):

    def __init__(self) -> None:
        patch_job_level_request = PatchJobLevelRequest()
        patch_job_level_request.http_method = HttpMethod.PATCH
        patch_job_level_request.uri = "/open-apis/corehr/v1/job_levels/:job_level_id"
        patch_job_level_request.token_types = {AccessTokenType.TENANT}
        self._patch_job_level_request: PatchJobLevelRequest = patch_job_level_request

    def client_token(self, client_token: str) -> "PatchJobLevelRequestBuilder":
        self._patch_job_level_request.client_token = client_token
        self._patch_job_level_request.add_query("client_token", client_token)
        return self

    def job_level_id(self, job_level_id: str) -> "PatchJobLevelRequestBuilder":
        self._patch_job_level_request.job_level_id = job_level_id
        self._patch_job_level_request.paths["job_level_id"] = str(job_level_id)
        return self

    def request_body(self, request_body: JobLevel) -> "PatchJobLevelRequestBuilder":
        self._patch_job_level_request.request_body = request_body
        self._patch_job_level_request.body = request_body
        return self

    def build(self) -> PatchJobLevelRequest:
        return self._patch_job_level_request
