# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .job import Job


class PatchJobRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.job_id: Optional[str] = None
        self.request_body: Optional[Job] = None

    @staticmethod
    def builder() -> "PatchJobRequestBuilder":
        return PatchJobRequestBuilder()


class PatchJobRequestBuilder(object):

    def __init__(self) -> None:
        patch_job_request = PatchJobRequest()
        patch_job_request.http_method = HttpMethod.PATCH
        patch_job_request.uri = "/open-apis/corehr/v1/jobs/:job_id"
        patch_job_request.token_types = {AccessTokenType.TENANT}
        self._patch_job_request: PatchJobRequest = patch_job_request

    def client_token(self, client_token: str) -> "PatchJobRequestBuilder":
        self._patch_job_request.client_token = client_token
        self._patch_job_request.add_query("client_token", client_token)
        return self

    def job_id(self, job_id: str) -> "PatchJobRequestBuilder":
        self._patch_job_request.job_id = job_id
        self._patch_job_request.paths["job_id"] = str(job_id)
        return self

    def request_body(self, request_body: Job) -> "PatchJobRequestBuilder":
        self._patch_job_request.request_body = request_body
        self._patch_job_request.body = request_body
        return self

    def build(self) -> PatchJobRequest:
        return self._patch_job_request
