# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .national_id_type import NationalIdType


class PatchNationalIdTypeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.national_id_type_id: Optional[str] = None
        self.request_body: Optional[NationalIdType] = None

    @staticmethod
    def builder() -> "PatchNationalIdTypeRequestBuilder":
        return PatchNationalIdTypeRequestBuilder()


class PatchNationalIdTypeRequestBuilder(object):

    def __init__(self) -> None:
        patch_national_id_type_request = PatchNationalIdTypeRequest()
        patch_national_id_type_request.http_method = HttpMethod.PATCH
        patch_national_id_type_request.uri = "/open-apis/corehr/v1/national_id_types/:national_id_type_id"
        patch_national_id_type_request.token_types = {AccessTokenType.TENANT}
        self._patch_national_id_type_request: PatchNationalIdTypeRequest = patch_national_id_type_request

    def client_token(self, client_token: str) -> "PatchNationalIdTypeRequestBuilder":
        self._patch_national_id_type_request.client_token = client_token
        self._patch_national_id_type_request.add_query("client_token", client_token)
        return self

    def national_id_type_id(self, national_id_type_id: str) -> "PatchNationalIdTypeRequestBuilder":
        self._patch_national_id_type_request.national_id_type_id = national_id_type_id
        self._patch_national_id_type_request.paths["national_id_type_id"] = str(national_id_type_id)
        return self

    def request_body(self, request_body: NationalIdType) -> "PatchNationalIdTypeRequestBuilder":
        self._patch_national_id_type_request.request_body = request_body
        self._patch_national_id_type_request.body = request_body
        return self

    def build(self) -> PatchNationalIdTypeRequest:
        return self._patch_national_id_type_request
