# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .rule_dimension import RuleDimension


class PermissionSecurityGroup(object):
    _types = {
        "rule_dimension": RuleDimension,
        "rule_type": int,
    }

    def __init__(self, d=None):
        self.rule_dimension: Optional[RuleDimension] = None
        self.rule_type: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PermissionSecurityGroupBuilder":
        return PermissionSecurityGroupBuilder()


class PermissionSecurityGroupBuilder(object):
    def __init__(self) -> None:
        self._permission_security_group = PermissionSecurityGroup()

    def rule_dimension(self, rule_dimension: RuleDimension) -> "PermissionSecurityGroupBuilder":
        self._permission_security_group.rule_dimension = rule_dimension
        return self

    def rule_type(self, rule_type: int) -> "PermissionSecurityGroupBuilder":
        self._permission_security_group.rule_type = rule_type
        return self

    def build(self) -> "PermissionSecurityGroup":
        return self._permission_security_group
