# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .address import Address
from .bank_account import BankAccount
from .dependent import Dependent
from .education import Education
from .email import Email
from .emergency_contact import EmergencyContact
from .enum import Enum
from .national_id import NationalId
from .object_field_data import ObjectFieldData
from .person_name import PersonName
from .personal_profile import PersonalProfile
from .phone import Phone
from .work_experience import WorkExperience


class Person(object):
    _types = {
        "phone_number": str,
        "legal_name": str,
        "preferred_name": str,
        "id": str,
        "name_list": List[PersonName],
        "gender": Enum,
        "date_of_birth": str,
        "nationality_id": str,
        "race": Enum,
        "marital_status": Enum,
        "phone_list": List[Phone],
        "address_list": List[Address],
        "email_list": List[Email],
        "work_experience_list": List[WorkExperience],
        "education_list": List[Education],
        "bank_account_list": List[BankAccount],
        "national_id_list": List[NationalId],
        "dependent_list": List[Dependent],
        "emergency_contact_list": List[EmergencyContact],
        "date_entered_workforce": str,
        "profile_image_id": str,
        "custom_fields": List[ObjectFieldData],
        "email_address": str,
        "resident_tax_id_list": List[str],
        "age": int,
        "highest_level_of_education": Education,
        "highest_degree_of_education": Education,
        "personal_profile": List[PersonalProfile],
    }

    def __init__(self, d=None):
        self.phone_number: Optional[str] = None
        self.legal_name: Optional[str] = None
        self.preferred_name: Optional[str] = None
        self.id: Optional[str] = None
        self.name_list: Optional[List[PersonName]] = None
        self.gender: Optional[Enum] = None
        self.date_of_birth: Optional[str] = None
        self.nationality_id: Optional[str] = None
        self.race: Optional[Enum] = None
        self.marital_status: Optional[Enum] = None
        self.phone_list: Optional[List[Phone]] = None
        self.address_list: Optional[List[Address]] = None
        self.email_list: Optional[List[Email]] = None
        self.work_experience_list: Optional[List[WorkExperience]] = None
        self.education_list: Optional[List[Education]] = None
        self.bank_account_list: Optional[List[BankAccount]] = None
        self.national_id_list: Optional[List[NationalId]] = None
        self.dependent_list: Optional[List[Dependent]] = None
        self.emergency_contact_list: Optional[List[EmergencyContact]] = None
        self.date_entered_workforce: Optional[str] = None
        self.profile_image_id: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        self.email_address: Optional[str] = None
        self.resident_tax_id_list: Optional[List[str]] = None
        self.age: Optional[int] = None
        self.highest_level_of_education: Optional[Education] = None
        self.highest_degree_of_education: Optional[Education] = None
        self.personal_profile: Optional[List[PersonalProfile]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PersonBuilder":
        return PersonBuilder()


class PersonBuilder(object):
    def __init__(self) -> None:
        self._person = Person()

    def phone_number(self, phone_number: str) -> "PersonBuilder":
        self._person.phone_number = phone_number
        return self

    def legal_name(self, legal_name: str) -> "PersonBuilder":
        self._person.legal_name = legal_name
        return self

    def preferred_name(self, preferred_name: str) -> "PersonBuilder":
        self._person.preferred_name = preferred_name
        return self

    def id(self, id: str) -> "PersonBuilder":
        self._person.id = id
        return self

    def name_list(self, name_list: List[PersonName]) -> "PersonBuilder":
        self._person.name_list = name_list
        return self

    def gender(self, gender: Enum) -> "PersonBuilder":
        self._person.gender = gender
        return self

    def date_of_birth(self, date_of_birth: str) -> "PersonBuilder":
        self._person.date_of_birth = date_of_birth
        return self

    def nationality_id(self, nationality_id: str) -> "PersonBuilder":
        self._person.nationality_id = nationality_id
        return self

    def race(self, race: Enum) -> "PersonBuilder":
        self._person.race = race
        return self

    def marital_status(self, marital_status: Enum) -> "PersonBuilder":
        self._person.marital_status = marital_status
        return self

    def phone_list(self, phone_list: List[Phone]) -> "PersonBuilder":
        self._person.phone_list = phone_list
        return self

    def address_list(self, address_list: List[Address]) -> "PersonBuilder":
        self._person.address_list = address_list
        return self

    def email_list(self, email_list: List[Email]) -> "PersonBuilder":
        self._person.email_list = email_list
        return self

    def work_experience_list(self, work_experience_list: List[WorkExperience]) -> "PersonBuilder":
        self._person.work_experience_list = work_experience_list
        return self

    def education_list(self, education_list: List[Education]) -> "PersonBuilder":
        self._person.education_list = education_list
        return self

    def bank_account_list(self, bank_account_list: List[BankAccount]) -> "PersonBuilder":
        self._person.bank_account_list = bank_account_list
        return self

    def national_id_list(self, national_id_list: List[NationalId]) -> "PersonBuilder":
        self._person.national_id_list = national_id_list
        return self

    def dependent_list(self, dependent_list: List[Dependent]) -> "PersonBuilder":
        self._person.dependent_list = dependent_list
        return self

    def emergency_contact_list(self, emergency_contact_list: List[EmergencyContact]) -> "PersonBuilder":
        self._person.emergency_contact_list = emergency_contact_list
        return self

    def date_entered_workforce(self, date_entered_workforce: str) -> "PersonBuilder":
        self._person.date_entered_workforce = date_entered_workforce
        return self

    def profile_image_id(self, profile_image_id: str) -> "PersonBuilder":
        self._person.profile_image_id = profile_image_id
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "PersonBuilder":
        self._person.custom_fields = custom_fields
        return self

    def email_address(self, email_address: str) -> "PersonBuilder":
        self._person.email_address = email_address
        return self

    def resident_tax_id_list(self, resident_tax_id_list: List[str]) -> "PersonBuilder":
        self._person.resident_tax_id_list = resident_tax_id_list
        return self

    def age(self, age: int) -> "PersonBuilder":
        self._person.age = age
        return self

    def highest_level_of_education(self, highest_level_of_education: Education) -> "PersonBuilder":
        self._person.highest_level_of_education = highest_level_of_education
        return self

    def highest_degree_of_education(self, highest_degree_of_education: Education) -> "PersonBuilder":
        self._person.highest_degree_of_education = highest_degree_of_education
        return self

    def personal_profile(self, personal_profile: List[PersonalProfile]) -> "PersonBuilder":
        self._person.personal_profile = personal_profile
        return self

    def build(self) -> "Person":
        return self._person
