# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .enum import Enum
from .object_field_data import ObjectFieldData
from .support_cost_center_item import SupportCostCenterItem


class PreHire(object):
    _types = {
        "ats_application_id": str,
        "id": str,
        "hire_date": str,
        "employee_type": Enum,
        "worker_id": str,
        "employee_type_id": str,
        "person_id": str,
        "custom_fields": List[ObjectFieldData],
        "cost_center_rate": List[SupportCostCenterItem],
        "onboarding_status": Enum,
    }

    def __init__(self, d=None):
        self.ats_application_id: Optional[str] = None
        self.id: Optional[str] = None
        self.hire_date: Optional[str] = None
        self.employee_type: Optional[Enum] = None
        self.worker_id: Optional[str] = None
        self.employee_type_id: Optional[str] = None
        self.person_id: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        self.cost_center_rate: Optional[List[SupportCostCenterItem]] = None
        self.onboarding_status: Optional[Enum] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PreHireBuilder":
        return PreHireBuilder()


class PreHireBuilder(object):
    def __init__(self) -> None:
        self._pre_hire = PreHire()

    def ats_application_id(self, ats_application_id: str) -> "PreHireBuilder":
        self._pre_hire.ats_application_id = ats_application_id
        return self

    def id(self, id: str) -> "PreHireBuilder":
        self._pre_hire.id = id
        return self

    def hire_date(self, hire_date: str) -> "PreHireBuilder":
        self._pre_hire.hire_date = hire_date
        return self

    def employee_type(self, employee_type: Enum) -> "PreHireBuilder":
        self._pre_hire.employee_type = employee_type
        return self

    def worker_id(self, worker_id: str) -> "PreHireBuilder":
        self._pre_hire.worker_id = worker_id
        return self

    def employee_type_id(self, employee_type_id: str) -> "PreHireBuilder":
        self._pre_hire.employee_type_id = employee_type_id
        return self

    def person_id(self, person_id: str) -> "PreHireBuilder":
        self._pre_hire.person_id = person_id
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "PreHireBuilder":
        self._pre_hire.custom_fields = custom_fields
        return self

    def cost_center_rate(self, cost_center_rate: List[SupportCostCenterItem]) -> "PreHireBuilder":
        self._pre_hire.cost_center_rate = cost_center_rate
        return self

    def onboarding_status(self, onboarding_status: Enum) -> "PreHireBuilder":
        self._pre_hire.onboarding_status = onboarding_status
        return self

    def build(self) -> "PreHire":
        return self._pre_hire
