# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .object_field_data import ObjectFieldData


class PreviousEmployer(object):
    _types = {
        "id": str,
        "employer_name": str,
        "employer_reference_number": str,
        "employment_order": int,
        "custom_fields": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.employer_name: Optional[str] = None
        self.employer_reference_number: Optional[str] = None
        self.employment_order: Optional[int] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PreviousEmployerBuilder":
        return PreviousEmployerBuilder()


class PreviousEmployerBuilder(object):
    def __init__(self) -> None:
        self._previous_employer = PreviousEmployer()

    def id(self, id: str) -> "PreviousEmployerBuilder":
        self._previous_employer.id = id
        return self

    def employer_name(self, employer_name: str) -> "PreviousEmployerBuilder":
        self._previous_employer.employer_name = employer_name
        return self

    def employer_reference_number(self, employer_reference_number: str) -> "PreviousEmployerBuilder":
        self._previous_employer.employer_reference_number = employer_reference_number
        return self

    def employment_order(self, employment_order: int) -> "PreviousEmployerBuilder":
        self._previous_employer.employment_order = employment_order
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "PreviousEmployerBuilder":
        self._previous_employer.custom_fields = custom_fields
        return self

    def build(self) -> "PreviousEmployer":
        return self._previous_employer
