# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_security_group_request_body import QuerySecurityGroupRequestBody


class QuerySecurityGroupRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[QuerySecurityGroupRequestBody] = None

    @staticmethod
    def builder() -> "QuerySecurityGroupRequestBuilder":
        return QuerySecurityGroupRequestBuilder()


class QuerySecurityGroupRequestBuilder(object):

    def __init__(self) -> None:
        query_security_group_request = QuerySecurityGroupRequest()
        query_security_group_request.http_method = HttpMethod.POST
        query_security_group_request.uri = "/open-apis/corehr/v1/security_groups/query"
        query_security_group_request.token_types = {AccessTokenType.TENANT}
        self._query_security_group_request: QuerySecurityGroupRequest = query_security_group_request

    def department_id_type(self, department_id_type: str) -> "QuerySecurityGroupRequestBuilder":
        self._query_security_group_request.department_id_type = department_id_type
        self._query_security_group_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self, request_body: QuerySecurityGroupRequestBody) -> "QuerySecurityGroupRequestBuilder":
        self._query_security_group_request.request_body = request_body
        self._query_security_group_request.body = request_body
        return self

    def build(self) -> QuerySecurityGroupRequest:
        return self._query_security_group_request
