# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class QueryTransferReasonRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.active: Optional[bool] = None
        self.transfer_reason_unique_identifier: Optional[List[str]] = None

    @staticmethod
    def builder() -> "QueryTransferReasonRequestBuilder":
        return QueryTransferReasonRequestBuilder()


class QueryTransferReasonRequestBuilder(object):

    def __init__(self) -> None:
        query_transfer_reason_request = QueryTransferReasonRequest()
        query_transfer_reason_request.http_method = HttpMethod.GET
        query_transfer_reason_request.uri = "/open-apis/corehr/v1/transfer_reasons/query"
        query_transfer_reason_request.token_types = {AccessTokenType.TENANT}
        self._query_transfer_reason_request: QueryTransferReasonRequest = query_transfer_reason_request

    def active(self, active: bool) -> "QueryTransferReasonRequestBuilder":
        self._query_transfer_reason_request.active = active
        self._query_transfer_reason_request.add_query("active", active)
        return self

    def transfer_reason_unique_identifier(self, transfer_reason_unique_identifier: List[
        str]) -> "QueryTransferReasonRequestBuilder":
        self._query_transfer_reason_request.transfer_reason_unique_identifier = transfer_reason_unique_identifier
        self._query_transfer_reason_request.add_query("transfer_reason_unique_identifier",
                                                      transfer_reason_unique_identifier)
        return self

    def build(self) -> QueryTransferReasonRequest:
        return self._query_transfer_reason_request
