# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .management_scope import ManagementScope
from .permission_detail import PermissionDetail


class RoleAuthorization(object):
    _types = {
        "employment_id": str,
        "permission_detail_list": List[PermissionDetail],
        "management_scope_list": List[ManagementScope],
    }

    def __init__(self, d=None):
        self.employment_id: Optional[str] = None
        self.permission_detail_list: Optional[List[PermissionDetail]] = None
        self.management_scope_list: Optional[List[ManagementScope]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RoleAuthorizationBuilder":
        return RoleAuthorizationBuilder()


class RoleAuthorizationBuilder(object):
    def __init__(self) -> None:
        self._role_authorization = RoleAuthorization()

    def employment_id(self, employment_id: str) -> "RoleAuthorizationBuilder":
        self._role_authorization.employment_id = employment_id
        return self

    def permission_detail_list(self, permission_detail_list: List[PermissionDetail]) -> "RoleAuthorizationBuilder":
        self._role_authorization.permission_detail_list = permission_detail_list
        return self

    def management_scope_list(self, management_scope_list: List[ManagementScope]) -> "RoleAuthorizationBuilder":
        self._role_authorization.management_scope_list = management_scope_list
        return self

    def build(self) -> "RoleAuthorization":
        return self._role_authorization
