# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_offboarding_request_body import SearchOffboardingRequestBody


class SearchOffboardingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[SearchOffboardingRequestBody] = None

    @staticmethod
    def builder() -> "SearchOffboardingRequestBuilder":
        return SearchOffboardingRequestBuilder()


class SearchOffboardingRequestBuilder(object):

    def __init__(self) -> None:
        search_offboarding_request = SearchOffboardingRequest()
        search_offboarding_request.http_method = HttpMethod.POST
        search_offboarding_request.uri = "/open-apis/corehr/v1/offboardings/search"
        search_offboarding_request.token_types = {AccessTokenType.TENANT}
        self._search_offboarding_request: SearchOffboardingRequest = search_offboarding_request

    def page_size(self, page_size: int) -> "SearchOffboardingRequestBuilder":
        self._search_offboarding_request.page_size = page_size
        self._search_offboarding_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SearchOffboardingRequestBuilder":
        self._search_offboarding_request.page_token = page_token
        self._search_offboarding_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "SearchOffboardingRequestBuilder":
        self._search_offboarding_request.user_id_type = user_id_type
        self._search_offboarding_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: SearchOffboardingRequestBody) -> "SearchOffboardingRequestBuilder":
        self._search_offboarding_request.request_body = request_body
        self._search_offboarding_request.body = request_body
        return self

    def build(self) -> SearchOffboardingRequest:
        return self._search_offboarding_request
